package gov.va.med.mhv.admin.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

import gov.va.med.mhv.common.data.model.UserProfile;

@Entity
@Table(name = "MHV_SM_TRACK_USER_AUTH")
public class MhvSMTrackUserAuth extends AbstractBaseEntity {
	private static final long serialVersionUID = 2783609252071444146L;

	@Id
	@Column(name = "MHV_SM_TRACK_USER_AUTH_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Version
	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "WELCOME_EMAIL_STATUS")
	private String welcomeEmailStatus;

	@Column(name = "SM_API_CALL_STATUS")
	private String smApiCallStatus;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "USER_PROFILE_ID", insertable = false, updatable = false)
	private Long userProfileId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_ID")
	private UserProfile userProfile;	
		
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getWelcomeEmailStatus() {
		return welcomeEmailStatus;
	}

	public void setWelcomeEmailStatus(String welcomeEmailStatus) {
		this.welcomeEmailStatus = welcomeEmailStatus;
	}

	public String getSmApiCallStatus() {
		return smApiCallStatus;
	}

	public void setSmApiCallStatus(String smApiCallStatus) {
		this.smApiCallStatus = smApiCallStatus;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

}
